-- pralable
-- USE BD_Air_France;

IF OBJECT_ID('dbo.T_affreter_aff','U') IS NOT NULL
   DROP TABLE dbo.T_affreter_aff;
GO
IF OBJECT_ID('dbo.T_avion_avi','U') IS NOT NULL
   DROP TABLE dbo.T_avion_avi;
GO

IF OBJECT_ID('dbo.T_personnel_prs','U') IS NOT NULL
   DROP TABLE dbo.T_personnel_prs;
GO
IF OBJECT_ID('dbo.T_contrats_ctr','U') IS NOT NULL
   DROP TABLE dbo.T_contrats_ctr;
GO
IF OBJECT_ID('dbo.T_compagnie_cmp','U') IS NOT NULL
   DROP TABLE dbo.T_compagnie_cmp;
GO
IF OBJECT_ID('dbo.T_aeroport_aer','U') IS NOT NULL
   DROP TABLE dbo.T_aeroport_aer;
GO




CREATE TABLE T_aeroport_aer
 (aer_IATA   VARCHAR(3),  aer_OACI   VARCHAR(6)  NOT NULL,
  aer_nom    VARCHAR(50) NOT NULL,
  CONSTRAINT PK_aer      PRIMARY KEY(aer_IATA));
GO

CREATE TABLE T_compagnie_cmp
 (cmp_comp VARCHAR(4), cmp_effectif INT, cmp_ville VARCHAR(30), cmp_nom VARCHAR(30),
  CONSTRAINT PK_cmp PRIMARY KEY(cmp_comp));
GO

CREATE TABLE T_contrats_ctr
(aer_IATA   VARCHAR(3), cmp_comp VARCHAR(4), ctr_bail DATE,
 CONSTRAINT PK_ctr PRIMARY KEY(aer_IATA,cmp_comp),
 CONSTRAINT FK_ctr_cmp FOREIGN KEY(cmp_comp) REFERENCES T_compagnie_cmp(cmp_comp),
 CONSTRAINT FK_ctr_aer FOREIGN KEY(aer_IATA) REFERENCES T_aeroport_aer(aer_IATA));
GO

CREATE TABLE T_personnel_prs
(prs_id INT, aer_IATA VARCHAR(3), cmp_comp VARCHAR(4), prs_ncpt VARCHAR(4),
 CONSTRAINT PK_prs PRIMARY KEY (prs_id,aer_IATA,cmp_comp),
 CONSTRAINT FK_prs_ctr FOREIGN KEY(aer_IATA,cmp_comp) REFERENCES T_contrats_ctr(aer_IATA,cmp_comp));
GO

INSERT INTO T_aeroport_aer VALUES ('TLS','LFBO','Toulouse Blagnac');
INSERT INTO T_aeroport_aer VALUES ('ORY','LFPO','Paris Orly');

INSERT INTO T_compagnie_cmp VALUES ('AF',6700,'Blagnac','Air France');
INSERT INTO T_compagnie_cmp VALUES ('AT',3400,'Castanet','Tolosan Air');

INSERT INTO T_contrats_ctr VALUES ('TLS','AF','2016-06-20');
INSERT INTO T_contrats_ctr VALUES ('ORY','AF','2015-03-01');
INSERT INTO T_contrats_ctr VALUES ('TLS','AT','2014-06-10');

INSERT INTO T_personnel_prs VALUES (102,'TLS','AT','A20');
INSERT INTO T_personnel_prs VALUES (104,'TLS','AT','A20');



